/****** Object:  View [dbo].[V_PAINEL_NFE_NF_SAIDA_PENDENTE_SOLUCAO_ANALITICO]    Script Date: 03/10/2018 11:00:00 ******/ 
IF EXISTS (SELECT * 
           FROM   SYS.VIEWS 
           WHERE  OBJECT_ID = 
      Object_id(N'[dbo].[V_PAINEL_NFE_NF_SAIDA_PENDENTE_SOLUCAO_ANALITICO]')) 
  DROP VIEW [dbo].[V_PAINEL_NFE_NF_SAIDA_PENDENTE_SOLUCAO_ANALITICO] 

GO 

--SELECT * FROM V_PAINEL_NFE_NF_SAIDA_PENDENTE_SOLUCAO_ANALITICO 
CREATE VIEW V_PAINEL_NFE_NF_SAIDA_PENDENTE_SOLUCAO_ANALITICO  
AS
SELECT DISTINCT 'Saída' AS tipoMotivacao ,
                nf.nf_nf AS numeroNfe ,
                nf.cd_nf AS codigoControle ,
                nf.dt_emi_nf AS data ,
                nf.vlr_nf AS valor ,
                nf.cd_filial AS filialOrigemId ,
                nf.nm_dest AS filialDestinoNome ,
                nf.cgc_cpf AS cgcCpf ,
                nf.insc_est AS inscricaoEstadual ,
                NFE.TIPO_NF AS tipo ,
                coalesce(lote_erro.ds_mot_err, 'Motivo erro não informado !') COLLATE Latin1_General_CI_AI AS motivoRejeicao ,
                coalesce(lote_erro.ds_err, 'Descrição do erro não informado !') COLLATE Latin1_General_CI_AI AS descricaoRejeicao ,
                0 AS cancelamento
FROM V_EST_NF_SAI_CAB NF
INNER JOIN V_EST_NF_NFE_PENDENTE_EMISSAO NFE ON NF.CD_EMP = NFE.CD_EMP
AND NF.CD_FILIAL = NFE.CD_FILIAL
AND NF.CD_NF = NFE.CD_NF
LEFT JOIN EST_NFE_LOTE_SAI LOTE_NF ON NFE.CD_EMP = LOTE_NF.CD_EMP
AND NFE.CD_FILIAL = LOTE_NF.CD_FILIAL
AND NFE.CD_NF = LOTE_NF.CD_NF
LEFT JOIN EST_NFE_LOTE_SAI_ERR LOTE_ERRO ON LOTE_ERRO.CD_NFE_LOTE = LOTE_NF.CD_NFE_LOTE
AND LOTE_ERRO.CD_NFE_LOTE_SAI = LOTE_NF.CD_NFE_LOTE_SAI
WHERE NFE.TIPO_NF IN (1, 2)
  AND NFE.PEND_SOLUC = 1
  AND NF.CD_EMP=1
UNION
SELECT DISTINCT 'Saída' AS movimentacao ,
                nf.nf_nf AS numeroDocumento ,
                nf.cd_nf AS codigoDocumento ,
                nf.dt_emi_nf AS dataDocumento ,
                nf.vlr_nf AS valorDocumento ,
                nf.cd_filial AS codigoFilial ,
                nf.nm_dest AS nomeDestinatario ,
                nf.cgc_cpf AS codigoPessoa ,
                nf.insc_est AS codigoContribuinte ,
                NFE.TIPO_NF AS tipo ,
                coalesce(lote_erro.ds_retorno, 'Motivo erro não informado !') COLLATE Latin1_General_CI_AI AS motivoRejeicao ,
                coalesce(lote_erro.ds_retorno, 'Descrição do erro não informado !') COLLATE Latin1_General_CI_AI AS descricaoRejeicao ,
                1 AS cancelamento
FROM EST_NF_SAI_NFE_CANCEL_ERR LOTE_ERRO
LEFT JOIN EST_NF_SAI_NFE_CANCEL CANC ON CANC.CD_EMP = LOTE_ERRO.CD_EMP
AND CANC.CD_FILIAL = LOTE_ERRO.CD_FILIAL
AND CANC.CD_NF = LOTE_ERRO.CD_NF
INNER JOIN V_EST_NF_SAI_CAB NF ON NF.CD_EMP = LOTE_ERRO.CD_EMP
AND NF.CD_FILIAL = LOTE_ERRO.CD_FILIAL
AND NF.CD_NF = LOTE_ERRO.CD_NF
INNER JOIN V_EST_NF_NFE_PENDENTE_EMISSAO NFE ON NF.CD_EMP = NFE.CD_EMP
AND NF.CD_FILIAL = NFE.CD_FILIAL
AND NF.CD_NF = NFE.CD_NF
WHERE canc.CD_NF IS NULL
  AND NFE.PEND_SOLUC = 1
  AND NFE.TIPO_NF IN (1, 2)
  AND NF.CD_EMP=1
